#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <time.h>
#include <GL/glut.h>

#define MAXSELECT 100
#define MAXFEED 300
#define SOLID 1
#define LINE 2
#define POINT 3

GLint windW = 300, windH = 300;

GLuint selectBuf[MAXSELECT];
GLfloat feedBuf[MAXFEED];
GLint vp[4];

struct object 
	{
	float v1[2];
	float v2[2];
	float v3[2];
	float color[3];
	} objects[10];

GLenum linePoly = GL_FALSE;

//
// 10 db vletlen hromszg
// 
void InitObjects()
	{
	GLint i;
	float x, y;

	srand((unsigned int) time(NULL));
	for (i = 0; i < 10; i++) 
		{
		x = (rand() % 300) - 150;
		y = (rand() % 300) - 150;

		objects[i].v1[0] = x + (rand() % 50) - 25;
		objects[i].v2[0] = x + (rand() % 50) - 25;
		objects[i].v3[0] = x + (rand() % 50) - 25;
		objects[i].v1[1] = y + (rand() % 50) - 25;
		objects[i].v2[1] = y + (rand() % 50) - 25;
		objects[i].v3[1] = y + (rand() % 50) - 25;
		objects[i].color[0] = ((rand() % 100) + 50) / 150.0;
		objects[i].color[1] = ((rand() % 100) + 50) / 150.0;
		objects[i].color[2] = ((rand() % 100) + 50) / 150.0;
		}
}

void Init()
	{
	InitObjects();
	}

void Reshape(int width, int height)
	{
	windW = width;
	windH = height;
	glViewport(0, 0, windW, windH);
	glGetIntegerv(GL_VIEWPORT, vp);
	}

//
// rendering s a szelekci neveinek belltasa
//
void Render(GLenum mode)
	{
	GLint i;

	for (i = 0; i < 10; i++) 
		{
		if (mode == GL_SELECT) 
			{
			glLoadName(i);
			}
		glColor3fv(objects[i].color);
		glBegin(GL_POLYGON);
			glVertex2fv(objects[i].v1);
			glVertex2fv(objects[i].v2);
			glVertex2fv(objects[i].v3);
		glEnd();
		}
	}

GLint DoSelect(GLint x, GLint y)
	{
	GLint hits;

	glSelectBuffer(MAXSELECT, selectBuf);
	glRenderMode(GL_SELECT);
	glInitNames();
	glPushName(0);

	glPushMatrix();

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPickMatrix(x, windH - y, 4, 4, vp);
	gluOrtho2D(-175, 175, -175, 175);
	glMatrixMode(GL_MODELVIEW);

	glClearColor(0.0, 0.0, 0.0, 0.0);
	glClear(GL_COLOR_BUFFER_BIT);

	glRotatef(90, 0, 0, 1);

	Render(GL_SELECT);

	glPopMatrix();

	hits = glRenderMode(GL_RENDER);
	if (hits <= 0) 
		{
		return -1;
		}
	return selectBuf[(hits - 1) * 4 + 3];
	}

//
// szn megvltoztatsa
//
void RecolorTri(GLint h)
	{
	objects[h].color[0] = ((rand() % 100) + 50) / 150.0;
	objects[h].color[1] = ((rand() % 100) + 50) / 150.0;
	objects[h].color[2] = ((rand() % 100) + 50) / 150.0;
	}
//
// hromszg mretnvelse
//
void GrowTri(GLint h)
	{
	float v[2];
	float *oldV;
	GLint i;

	v[0] = objects[h].v1[0] + objects[h].v2[0] + objects[h].v3[0];
	v[1] = objects[h].v1[1] + objects[h].v2[1] + objects[h].v3[1];
	v[0] /= 3;
	v[1] /= 3;

	for (i = 0; i < 3; i++) 
		{
		switch (i) 
			{
			case 0:
				oldV = objects[h].v1;
			break;
			case 1:
				oldV = objects[h].v2;
			break;
			case 2:
				oldV = objects[h].v3;
			break;
			}
		oldV[0] = 1.5 * (oldV[0] - v[0]) + v[0];
		oldV[1] = 1.5 * (oldV[1] - v[1]) + v[1];
		}
	}
//
// egr nagyt vagy kivlaszt
//
void Mouse(int button, int state, int mouseX, int mouseY)
	{
	GLint hit;

	if (state == GLUT_DOWN) 
		{
		hit = DoSelect((GLint) mouseX, (GLint) mouseY);		// kivlaszts
		if (hit != -1) 
			{
			if (button == GLUT_LEFT_BUTTON) 
				{
				RecolorTri(hit);
				} 
			else if (button == GLUT_MIDDLE_BUTTON) 
				{
				GrowTri(hit);
				} 
			glutPostRedisplay();
			}
		}
	}

void Draw()
	{
	glPushMatrix();
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(-175, 175, -175, 175);
	glMatrixMode(GL_MODELVIEW);
	glClearColor(0.0, 0.0, 0.0, 0.0);
	glClear(GL_COLOR_BUFFER_BIT);
	glRotatef(90, 0, 0, 1);
	Render(GL_RENDER);
	glPopMatrix();
	glutSwapBuffers();
	}

void DumpFeedbackVert(GLint * i, GLint n)
	{
	GLint index;

	index = *i;
	
	if (index + 7 > n) 
		{
		*i = n;
		printf("  ???\n");
		return;
		}

	printf("  (%g %g %g), color = (%4.2f %4.2f %4.2f)\n",
	feedBuf[index],
	feedBuf[index + 1],
	feedBuf[index + 2],
	feedBuf[index + 3],
	feedBuf[index + 4],
	feedBuf[index + 5]);
	index += 7;
	*i = index;
	}

void DrawFeedback(GLint n)
	{
	GLint i;
	GLint verts;

	printf("A feedback eredmenye (%d float):\n", n);
	
	for (i = 0; i < n; i++) 
		{
		switch ((GLint) feedBuf[i]) 
			{
			case GL_POLYGON_TOKEN:
				printf("Poligon");
				i++;
				if (i < n) 
					{
					verts = (GLint) feedBuf[i];
					i++;
					printf(": %d vertex", verts);
					} 
				else 
					{
					verts = 0;
					}
				printf("\n");
				while (verts) 
					{
					DumpFeedbackVert(&i, n);
					verts--;
					}
				i--;
				break;
		case GL_LINE_TOKEN:
			printf("Vonal:\n");
			i++;
			DumpFeedbackVert(&i, n);
			DumpFeedbackVert(&i, n);
			i--;
			break;
		case GL_LINE_RESET_TOKEN:
			printf("Vonal Reset:\n");
			i++;
			DumpFeedbackVert(&i, n);
			DumpFeedbackVert(&i, n);
			i--;
			break;
		default:
			printf("%9.2f\n", feedBuf[i]);
		break;
		}
	}
	if (i == MAXFEED) 
		{
		printf("...\n");
		}
	printf("\n");
	}

void DoFeedback(void)
	{
	GLint x;

	glFeedbackBuffer(MAXFEED, GL_3D_COLOR, feedBuf);
	(void) glRenderMode(GL_FEEDBACK);

	glPushMatrix();

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluOrtho2D(-175, 175, -175, 175);
	glMatrixMode(GL_MODELVIEW);

	glClearColor(0.0, 0.0, 0.0, 0.0);
	glClear(GL_COLOR_BUFFER_BIT);

	glRotatef(90, 0, 0, 1);

	Render(GL_FEEDBACK);

	glPopMatrix();

	x = glRenderMode(GL_RENDER);
	if (x == -1) 
		{
		x = MAXFEED;
		}
	
	DrawFeedback((GLint) x);
	}

void Key(unsigned char key, int x, int y)
	{
	switch (key) 
		{
		case 'f':
			DoFeedback();
			glutPostRedisplay();
		break;
		case 'l':
			linePoly = !linePoly;
			if (linePoly) 
				{
				glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
				}
			else 
				{
				glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
				}
			glutPostRedisplay();
		break;
		}
	}

int main(int argc, char **argv)
	{
	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE);
	glutCreateWindow("3D kivalasztas");
	Init();
	glutReshapeFunc(Reshape);
	glutKeyboardFunc(Key);
	glutMouseFunc(Mouse);
	glutDisplayFunc(Draw);
	glutMainLoop();
	return 0;
	}
